/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.protocol;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

import com.wabit.uecs.UecsConstants;

/**
 * 通信子スキャン要求CCMクラスです。
 * @author WaBit
 *
 */
public class CcmScanCcm extends XmlCcm {

    /** CCMSCANタグ名 */
    public static final String TAG_CCMSCAN = "CCMSCAN";

    /** page属性名 */
    public static final String ATTR_PAGE = "page";

    private int page = 1;

    /**
     * リストのページ番号を取得します。
     * @return ページ番号
     */
    public int getPage() {
        return page;
    }

    /**
     * リストのページ番号を設定します。
     * @param page
     */
    public void setPage(int page) {
        this.page = page;
    }

    @Override
    void appendXml(StringBuilder sb) {
        sb.append("<").append(TAG_CCMSCAN);
        if (page > 0) {
            sb.append(" ").append(ATTR_PAGE).append("=\"" + page + "\"/>");
        } else {
            sb.append("/>");
        }
    }

    @Override
    void importXml(Document doc) throws Exception {
        Element elm = (Element) doc.getElementsByTagName(TAG_CCMSCAN).item(0);
        String val = elm.getAttribute(ATTR_PAGE);
        if (val.length() != 0) {
            setPage(Integer.parseInt(val));
        } else {
            setPage(1);
        }

    }

    @Override
    public int getPort() {
        return UecsConstants.SCAN_PORT;
    }

    @Override
    void setXmlAttributes(String tagName, Attributes attributes) {
        if (TAG_CCMSCAN.equals(tagName)) {
            String val = attributes.getValue(ATTR_PAGE);
            if (val.length() != 0) {
                setPage(Integer.parseInt(val));
            } else {
                setPage(1);
            }
        }
    }

    @Override
    void setXmlValue(String tagName, String value) {
        // TODO Auto-generated method stub

    }

}
