/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.device;

import java.util.List;

/**
 * デバイスを構成するコンポーネント（部品）インタフェース.
 *
 * @author WaBit
 * @param <T> 関連付けるコンポーネント設定クラス
 */
public interface IComponent<T extends ComponentConfig> {

	/**
	 * 設定値オブジェクトを取得します。
	 * @return 設定オブジェクト
	 */
	public T getConfig();

    /**
     * IDを取得します。
     * @return ID
     */
    public String getId();

    /**
     * 保有している値を取得します。
     *
     * @return 数値
     */
    public Number getValue();

    /**
     * 所属しているデバイスを取得します。
     * @return デバイスオブジェクト
     */
    public IDevice<?> getDevice();

    /**
     * 値を設定します。
     * @param value 数値
     */
    public void setValue(Number value);

    /**
     * リスナーを登録します。
     * @param listener リスナーオブジェクト
     */
    public void addListener(IComponentListener listener);

    /**
     * 登録されているリスナー一覧を取得します。
     * @return リスナー一覧
     */
    public List<IComponentListener> getListeners();

    /**
     * リスナーを削除します。
     * @param listener 削除したいリスナー
     * @return 削除されるとtrue
     */
    public boolean removeListener(IComponentListener listener);

    /**
     * 初期化処理を実行します。
     * @param device 所属するデバイス
     * @throws Exception 処理に失敗するとスローされます。
     */
    public void init(IDevice<?> device) throws Exception;

    /**
     * 動作を開始します。
     * @throws Exception 処理に失敗するとスローされます。
     */
    public void start() throws Exception;

    /**
     * 動作を終了させます。
     * @throws Exception 処理に失敗するとスローされます。
     */
    public void stop() throws Exception;


}
