/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs;

import java.net.InetAddress;

/**
 * CCM応答クラスです。
 * @author WaBit
 *
 */
public class UecsResponse {

    private InetAddress address;
    private byte[] data;
    private int port;

    /**
     * 応答先アドレスを取得します。
     * @return IPアドレス
     */
    public InetAddress getAddress() {
        return address;
    }

    /**
     * 応答先アドレスを設定します。
     * @param address IPアドレス
     */
    public void setAddress(InetAddress address) {
        this.address = address;
    }

    /**
     * 応答データを取得します。
     * @return データ配列
     */
    public byte[] getData() {
        return data;
    }

    /**
     * 応答データを設定します。
     * @param data データ配列
     */
    public void setData(byte[] data) {
        this.data = data;
    }

    /**
     * 保持データが有効であるかを取得します。
     * @return 有効であればtrue
     */
    public boolean isValid() {
        if (address != null && port > 0 && data != null) {
            return true;
        }
        return false;
    }

    /**
     * 応答送信ポートを取得します。
     * @return ポート番号
     */
    public int getPort() {
        return port;
    }

    /**
     * 応答送信ポートを設定します。
     * @param port ポート番号
     */
    public void setPort(int port) {
        this.port = port;
    }
}
