/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.ccm;

import com.wabit.uecs.Ccm;
import com.wabit.uecs.CcmID;
import com.wabit.uecs.CcmLevel;
import com.wabit.uecs.UecsConstants;

/**
 * 遠隔制御指示CCM（rcA.kNN）
 * @author WaBit
 *
 */
public class RcACcm extends Ccm {

    /**
     * コンストラクタ
     * @param nodeType ノード種別(kNN)
     */
    public RcACcm(String nodeType) {
        this(nodeType, "");
    }

    /**
     * コンストラクタ
     * @param nodeType ノード種別(kNN)
     * @param infoName 項目名(xxx)
     */
    public RcACcm(String nodeType, String infoName) {
        this(nodeType, infoName, 0);
    }

    /**
     * コンストラクタ
     * @param nodeType ノード種別(kNN)
     * @param infoName 項目名(xxx)
     * @param no 系統番号
     */
    public RcACcm(String nodeType, String infoName, int no) {
        StringBuilder type = new StringBuilder();
        if (infoName != null) {
            type.append(infoName);
        }
        type.append("rcA");
        if (no > 0) {
            type.append(".").append(no);
        }
        if (nodeType != null && nodeType.length() > 0) {
            type.append(".").append(nodeType);
        }
        super.setType(new CcmID(type.toString()));
        super.setLevel(CcmLevel.S_1M_0);
        super.setSide(UecsConstants.RECEIVER);
        super.setCast(0);
    }

    /**
     * 本CCMでは規約で固定されているのでサポートされません。
     */
    @Override
    public void setType(CcmID type) {
        throw new UnsupportedOperationException();
    }

    /**
     * 本CCMでは規約で固定されているのでサポートされません。
     */
    @Override
    public void setLevel(CcmLevel level) {
        throw new UnsupportedOperationException();
    }

    /**
     * 本CCMでは規約で固定されているのでサポートされません。
     */
    @Override
    public void setCast(int cast) {
        throw new UnsupportedOperationException();
    }

}
