/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.ccm;

import java.text.DecimalFormat;

import com.wabit.uecs.Ccm;
import com.wabit.uecs.CcmID;
import com.wabit.uecs.CcmLevel;
import com.wabit.uecs.IUecsNode;
import com.wabit.uecs.UecsConstants;

/**
 * 機器動作状態CCM（cnd.kNN）
 * @author WaBit
 *
 */
public class CndCcm extends Ccm {

    private IUecsNode<?> node;

    /**
     * コンストラクタ。
     * @param node 状態を監視するノードインスタンス
     * @param nodeType ノード種別名(kNN)
     */
    public CndCcm(IUecsNode<?> node, String nodeType) {
        this.node = node;
        super.setType(new CcmID("cnd." + nodeType));
        super.setLevel(CcmLevel.A_1S_0);
        super.setSide(UecsConstants.SENDER);
        super.setCast(0);
    }

    /**
     * 本CCMでは規約で固定されているのでサポートされません。
     */
    @Override
    public void setType(CcmID type) {
        throw new UnsupportedOperationException();
    }

    /**
     * 本CCMでは規約で固定されているのでサポートされません。
     */
    @Override
    public void setLevel(CcmLevel level) {
        throw new UnsupportedOperationException();
    }

    /**
     * 本CCMでは規約で固定されているのでサポートされません。
     */
    @Override
    public void setCast(int cast) {
        throw new UnsupportedOperationException();
    }

    /**
     * 送信側の場合はノードからステータス値を取得します。
     * 受信側は、受信した値を取得します。
     *
     * @return 状態ステータス値(32ビット)
     */
    @Override
    public Number getNumberValue() {
        if (UecsConstants.SENDER == getSide()) {
            return node.getStatus();
        }
        return super.getNumberValue();
    }

    /**
     * 整数文字列型で値を取得します。
     *
     * @return 整数文字列。null値の場合は空文字が返ります。
     */
    @Override
    public String getStringValue() {
        Number num = getNumberValue();
        if (num != null) {
            return new DecimalFormat(getFormat()).format(num);
        }
        return null;
    }

    /**
     * 二進数表記で取得します。
     *
     * @return 二進数文字列。null値の場合は空文字が返ります。
     */
    public String getBinaryStringValue() {
        Number num = getNumberValue();
        if (num != null) {
            return Integer.toBinaryString(num.intValue());
        }
        return null;
    }

}
