package myapp.webui.sample2;

import java.util.concurrent.Callable;

import myapp.device.sample2.SimpleGpioDevice;
import myapp.device.sample2.TimerSwitchActuator;
import myapp.device.sample2.TimerSwitchActuatorConfig;
import myapp.webui.MyUIApplication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.validation.validator.RangeValidator;
import org.apache.wicket.validation.validator.StringValidator;

import com.wabit.uecs.pi.UecsPiNode;
import com.wabit.uecs.pi.db.DatabaseManager;
import com.wabit.uecs.pi.db.DatabaseUtils;
import com.wabit.uecs.pi.util.MessageCode;
import com.wabit.uecs.pi.util.MessageUtils;
import com.wabit.uecs.pi.webui.LayoutPage;
import com.wabit.uecs.util.PropertyConfig;

@AuthorizeInstantiation({Roles.ADMIN})
public class GpioActuatorPage extends LayoutPage {
    private static final long serialVersionUID = 9205561784306869639L;

    private Form<PropertyConfig> deviceForm;
    private PropertyConfig formParams = new PropertyConfig();
    private Log logger = LogFactory.getLog(getClass());
    private String deviceId;
    private String componentId;

    public GpioActuatorPage() {
    }

    public GpioActuatorPage(IModel<?> settingsModel) {
        super(settingsModel);
    }

    public GpioActuatorPage(PageParameters parameters) {
        super(parameters);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        UecsPiNode node = MyUIApplication.getNodeInstance();
        SimpleGpioDevice device = (SimpleGpioDevice)(node.listDevices(SimpleGpioDevice.class).get(0));
        TimerSwitchActuator component = device.listComponents(TimerSwitchActuator.class).get(0);
        deviceId = device.getId();
        componentId = component.getId();

        formParams.putAll(component.getConfig());

        deviceForm = new Form<PropertyConfig>("deviceForm") {
            private static final long serialVersionUID = 1L;

            @Override
            public void onSubmit() {
                try {
                    deviceForm.modelChanging();
                    DatabaseManager.callInTransaction(new Callable<Void>() {
                        public Void call() throws Exception {
                            TimerSwitchActuator component = (TimerSwitchActuator) MyUIApplication.getNodeInstance()
                                    .getDevice(deviceId)
                                    .getComponent(componentId);
                            component.getConfig().putAll(formParams);
                            DatabaseUtils.saveComponent(deviceId, component);
                            MyUIApplication.getNodeInstance().restart();
                            return null;
                        }
                    });
                    deviceForm.modelChanged();
                    success(MessageUtils.getMessage(MessageCode.SAVED));
                } catch (Exception e) {
                    error(MessageUtils.getMessage(MessageCode.ERROR));
                    logger.error("save error.", e);
                }
            }

        };

        deviceForm.setDefaultModel(new CompoundPropertyModel<PropertyConfig>(formParams));
        deviceForm.add(new RequiredTextField<String>(TimerSwitchActuatorConfig.KEY_COMPONENT_NAME,
                String.class)
                .add(new StringValidator(1, 50)));
        deviceForm.add(new TextField<String>(TimerSwitchActuatorConfig.KEY_CCM_INFO_NAME,
                String.class)
                .add(new StringValidator(1, 12)));
        deviceForm.add(new TextField<Integer>(TimerSwitchActuatorConfig.KEY_CCM_LINE, Integer.class)
                .add(new RangeValidator<Integer>(0, 127)));
        deviceForm.add(new TextField<String>(TimerSwitchActuatorConfig.KEY_CCM_NODE_TYPE,
                String.class)
                .setConvertEmptyInputStringToNull(false).add(new StringValidator(0, 3)));
        deviceForm.add(new CheckBox(TimerSwitchActuatorConfig.KEY_INVERSE).setRequired(true));

        // 定期動作設定フォーム
        deviceForm.add(new RequiredTextField<Integer>(TimerSwitchActuatorConfig.KEY_PERIODIC_INTERVAL, Integer.class)
                .add(new RangeValidator<Integer>(1, Integer.MAX_VALUE)));
        deviceForm.add(new RequiredTextField<Integer>(TimerSwitchActuatorConfig.KEY_PERIODIC_ON,
                Integer.class)
                .add(new RangeValidator<Integer>(1, Integer.MAX_VALUE)));
        deviceForm
                .add(new TextField<Integer>(TimerSwitchActuatorConfig.KEY_PERIODIC_INACTIVE_START_HOUR, Integer.class)
                        .add(new RangeValidator<Integer>(0, 23)));
        deviceForm.add(new TextField<Integer>(TimerSwitchActuatorConfig.KEY_PERIODIC_INACTIVE_START_MIN, Integer.class)
                .add(new RangeValidator<Integer>(0, 59)));
        deviceForm.add(new TextField<Integer>(TimerSwitchActuatorConfig.KEY_PERIODIC_INACTIVE_END_HOUR, Integer.class)
                .add(new RangeValidator<Integer>(0, 23)));
        deviceForm.add(new TextField<Integer>(TimerSwitchActuatorConfig.KEY_PERIODIC_INACTIVE_END_MIN, Integer.class)
                .add(new RangeValidator<Integer>(0, 59)));

        add(deviceForm);

    }

}
