package myapp.device.sample2;

import com.wabit.uecs.ActionMode;
import com.wabit.uecs.device.actuator.PeriodicSwitchAction;
import com.wabit.uecs.pi.device.gpio.DigitalSwitchActuator;

public class TimerSwitchActuator extends DigitalSwitchActuator<TimerSwitchActuatorConfig> {

    public TimerSwitchActuator(String id) {
        super(id, new TimerSwitchActuatorConfig());

    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();

        TimerSwitchActuatorConfig config = getConfig();
        int periodicInterval = config.getInt(TimerSwitchActuatorConfig.KEY_PERIODIC_INTERVAL, 0);
        int onInterval = config.getInt(TimerSwitchActuatorConfig.KEY_PERIODIC_ON, 0);

        if (periodicInterval > 0 && onInterval > 0) {
            // 設定値が有効な場合は、定周期動作
            PeriodicSwitchAction periodAction = new PeriodicSwitchAction();
            periodAction.setPeriodicInterval(periodicInterval * 1000L);
            periodAction.setOnInterval(onInterval * 1000L);
            periodAction.setInactiveStartTime(config.getInt(TimerSwitchActuatorConfig.KEY_PERIODIC_INACTIVE_START_HOUR, -1),
                    config.getInt(TimerSwitchActuatorConfig.KEY_PERIODIC_INACTIVE_START_MIN, -1));
            periodAction.setInactiveEndTime(config.getInt(TimerSwitchActuatorConfig.KEY_PERIODIC_INACTIVE_END_HOUR, -1),
                    config.getInt(TimerSwitchActuatorConfig.KEY_PERIODIC_INACTIVE_END_MIN, -1));
            setAction(ActionMode.Autonomy, periodAction);
            setActionMode(ActionMode.Autonomy);
        } else {
            // 何も設定されない場合は、スタンドアローンモードで起動
            setActionMode(ActionMode.Standalone);
        }
    }


}
