/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.util;

import java.io.ByteArrayOutputStream;
import java.net.InetAddress;

/**
 * 共通ユーティリティです。
 *
 * @author WaBit
 *
 */
public class CommonUtils {

    // コンストラクタ隠ぺい
    private CommonUtils() {

    }

    /**
     * 16進数表記をバイト配列に変換します。
     *
     * @param hex HEX表現文字列
     * @return バイト値
     */
    public static byte[] hexToBytes(String hex) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < hex.length(); i += 2) {
            int b = Integer.parseInt(hex.substring(i, i + 2), 16);
            baos.write(b);
        }
        byte[] result = baos.toByteArray();
        return result;
    }

    /**
     * バイト配列を16進数表記に変換します。
     *
     * @param data 変換対象バイト配列
     * @return HEX表記文字列
     */
    public static String bytesToHex(byte[] data) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; i++) {
            sb.append(String.format("%02X", data[i]));
        }
        return sb.toString();
    }

    /**
     * 文字列表記アドレスをバイト配列アドレスに変換します。
     *
     * @param address IPアドレス文字列
     * @return IPアドレス。変換に失敗した場合はnullが返却されます。
     */
    public static byte[] addressToBytes(String address) {
        try {
            return InetAddress.getByName(address).getAddress();
        } catch (Exception e) {
            return null;
        }
    }
}
