/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.ccm;

import java.text.SimpleDateFormat;
import java.util.Date;

import com.wabit.uecs.Ccm;
import com.wabit.uecs.CcmID;
import com.wabit.uecs.CcmLevel;
import com.wabit.uecs.UecsConstants;

/**
 * 時刻送信用CCM(Time)実装です。
 * @author WaBit
 *
 */
public class TimeCcm extends Ccm {

    private static final CcmID CCM_TYPE = new CcmID("Time");

    private static final String FORMAT = "HHmmss";

    /**
     * デフォルト値のインスタンスを返します。
     */
    public TimeCcm() {
        super.setType(CCM_TYPE);
        super.setLevel(CcmLevel.A_1M_0);
        super.setSide(UecsConstants.SENDER);
        super.setRoom(0);
        super.setRegion(0);
        super.setOrder(0);
        super.setPriority(0);
        super.setCast(0);
    }

    /**
     * 本CCMでは規約で固定されているのでサポートされません。
     */
    @Override
    public void setType(CcmID type) {
        throw new UnsupportedOperationException();
    }

    /**
     * 本CCMでは規約で固定されているのでサポートされません。
     */
    @Override
    public void setLevel(CcmLevel level) {
        throw new UnsupportedOperationException();
    }

    /**
     * 本CCMでは規約で固定されているのでサポートされません。
     */
    @Override
    public void setCast(int cast) {
        throw new UnsupportedOperationException();
    }

    /**
     * 送信側はJavaのシステム時刻から自動的に値を取得します。
     * 受信側は受信したデータを取得します。
     *
     * @return 時刻文字列(HHMMSS)
     */
    @Override
    public Number getNumberValue() {
        if (UecsConstants.SENDER == getSide()) {
            SimpleDateFormat df = new SimpleDateFormat(FORMAT);
            String val = df.format(new Date());
            return Integer.parseInt(val);
        }
        return super.getNumberValue();
    }

    /**
     * 送信側はJavaのシステム時刻から自動的に値を取得します。
     * 受信側は、受信データを取得します。
     *
     * @return 時刻文字列(HHMMSS)
     */
    @Override
    public String getStringValue() {
        if (UecsConstants.SENDER == getSide()) {
            return getNumberValue().toString();
        }
        return super.getStringValue();
    }
}
