/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs;

/**
 * UECS規約で定義されている、各種の定数定義クラスです。
 *
 * @author WaBit
 *
 */
public class UecsConstants {

    /** データ通信ポート番号 16520 */
    public static final int DATA_PORT = 16520;
    /** サーチ通信ポート番号 16521 */
    public static final int SEARCH_PORT = 16521;
    /** スキャン通信ポート番号 16529 */
    public static final int SCAN_PORT = 16529;
    /** UDPパケットサイズ */
    public static final int UDP_PACKET_SIZE = 512;

    /** UECS規約のメッセージ最大サイズ(480Byte) */
    public static final int MAX_CCM_SIZE = 480;

    /** メッセージのデフォルト文字コード (iso-8859-1を規約で定められた8bit iso-646-1991として使用します） */
    public static final String DEFAULT_CHARSET = "iso-8859-1";

    /** UECS通信実用規約バージョン */
    public static final String DEFAULT_VERSION = "1.00-E10";

    /** 送信側 'S' */
    public static final char SENDER = 'S';

    /** 受信側 'R' */
    public static final char RECEIVER = 'R';

    /** 通信レベル A */
    public static final char LEVEL_A = 'A';

    /** 通信レベル B */
    public static final char LEVEL_B = 'B';

    /** 通信レベル C */
    public static final char LEVEL_S = 'S';

    /** 機器動作状態マスク ： 全領域(0-31bit) */
    public static final int STATUS_AREA_ALL = 0xFFFFFFFF;

    /** 機器動作状態マスク ： ユーザー定義領域(0-11bit) */
    public static final int STATUS_AREA_USER = 0x00000FFF;

    /** 機器動作状態マスク ： 拡張用予約領域(12-15bit) */
    public static final int STATUS_AREA_EXTENSION = 0x0000F000;

    /** 機器動作状態マスク ： モード領域(16-19bit) */
    public static final int STATUS_AREA_MODE = 0x000F0000;

    /** 機器動作状態マスク ： 軽度の障害領域(20-25bit) */
    public static final int STATUS_AREA_ATTENTION = 0x03F00000;

    /** 機器動作状態マスク ： 重度の障害領域(26-30bit) */
    public static final int STATUS_AREA_ALERT = 0x7C000000;

    /** 機器動作状態 ： rcAモード */
    public static final int MODE_rcA = 0x00010000;

    /** 機器動作状態 ： WEB強制操作モード */
    public static final int MODE_WEB = 0x00020000;

    /** 機器動作状態 ： rcMモード */
    public static final int MODE_rcM = 0x00030000;

    /** 機器動作状態 ： インターロックモード */
    public static final int MODE_INTERLOCK = 0x00040000;

    /** 機器動作状態 ： 強制停止モード */
    public static final int MODE_OUTAGE = 0x00050000;

    /** 機器動作状態 ： スタンドアローンモード */
    public static final int MODE_STANDALONE = 0x00060000;

    /** 機器動作状態 ： 自律モード */
    public static final int MODE_AUTONOMY = 0x00000000;

    /** 機器動作状態 ： 正常 */
    public static final int STATUS_NORMAL = 0x00000000;

    /** 機器動作状態 ： CCM受信処理エラー */
    public static final int STATUS_ATTENTION_CCM_RECV_ERROR = 0x00100000;

    /** 機器動作状態 ： 初期処理失敗 */
    public static final int STATUS_ALART_INIT_FAILED = 0x04000000;

    /** 機器動作状態 ： 通信処理エラー */
    public static final int STATUS_ALART_COMMUNICATION_ERROR = 0x08000000;


    private UecsConstants() {

    }

}
