package myapp.webui.sample3;

import java.util.concurrent.Callable;

import myapp.device.sample3.RegexSensor;
import myapp.device.sample3.RegexSensorConfig;
import myapp.device.sample3.SimpleSerialDevice;
import myapp.device.sample3.SimpleSerialDeviceConfig;
import myapp.webui.MyUIApplication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.validation.validator.RangeValidator;
import org.apache.wicket.validation.validator.StringValidator;

import com.wabit.uecs.pi.UecsPiNode;
import com.wabit.uecs.pi.db.DatabaseManager;
import com.wabit.uecs.pi.db.DatabaseUtils;
import com.wabit.uecs.pi.device.serial.SerialPortDeviceConfig;
import com.wabit.uecs.pi.util.MessageCode;
import com.wabit.uecs.pi.util.MessageUtils;
import com.wabit.uecs.pi.webui.LayoutPage;
import com.wabit.uecs.util.PropertyConfig;

/**
 * シリアル通信を行うデバイス設定のサンプルページクラスです。
 */
@AuthorizeInstantiation({ Roles.ADMIN })
public class SerialDevicePage extends LayoutPage {
    private static final long serialVersionUID = 9205561784306869639L;

    private Form<PropertyConfig> deviceForm;
    private PropertyConfig formParams = new PropertyConfig();
    private Log logger = LogFactory.getLog(getClass());
    private String deviceId;

    public SerialDevicePage() {
    }

    public SerialDevicePage(IModel<?> settingsModel) {
        super(settingsModel);
    }

    public SerialDevicePage(PageParameters parameters) {
        super(parameters);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        UecsPiNode node = MyUIApplication.getNodeInstance();
        SimpleSerialDevice device = node.listDevices(SimpleSerialDevice.class).get(0);
        deviceId = device.getId();
        formParams.setString(SimpleSerialDeviceConfig.KEY_SERIAL_PORT_ID,
                device.getConfig().getString(SimpleSerialDeviceConfig.KEY_SERIAL_PORT_ID));
        formParams.setString(SimpleSerialDeviceConfig.KEY_SERIAL_PORT_SPEED,
                device.getConfig().getString(SimpleSerialDeviceConfig.KEY_SERIAL_PORT_SPEED));
        RegexSensor sensor = device.listComponents(RegexSensor.class).get(0);
        formParams.setString(RegexSensorConfig.KEY_REGEX_PATTERN,
                sensor.getConfig().getString(RegexSensorConfig.KEY_REGEX_PATTERN));

        deviceForm = new Form<PropertyConfig>("deviceForm") {
            private static final long serialVersionUID = 1L;

            @Override
            public void onSubmit() {
                try {
                    deviceForm.modelChanging();
                    DatabaseManager.callInTransaction(new Callable<Void>() {
                        public Void call() throws Exception {
                            SimpleSerialDevice device = (SimpleSerialDevice) MyUIApplication.getNodeInstance()
                                        .getDevice(deviceId);
                            RegexSensor sensor = device.listComponents(RegexSensor.class).get(0);

                            device.getConfig().setString(SimpleSerialDeviceConfig.KEY_SERIAL_PORT_ID,
                                    formParams.getString(SimpleSerialDeviceConfig.KEY_SERIAL_PORT_ID));
                            device.getConfig().setInt(SimpleSerialDeviceConfig.KEY_SERIAL_PORT_SPEED,
                                    formParams.getInt(SimpleSerialDeviceConfig.KEY_SERIAL_PORT_SPEED));
                            sensor.getConfig().setString(RegexSensorConfig.KEY_REGEX_PATTERN,
                                    formParams.getString(RegexSensorConfig.KEY_REGEX_PATTERN));
                            DatabaseUtils.saveDevice(device);
                            MyUIApplication.getNodeInstance().restart();
                            return null;
                        }
                    });
                    deviceForm.modelChanged();
                    success(MessageUtils.getMessage(MessageCode.SAVED));
                } catch (Exception e) {
                    error(MessageUtils.getMessage(MessageCode.ERROR));
                    logger.error("save error.", e);
                }
            }
        };

        deviceForm.setDefaultModel(new CompoundPropertyModel<PropertyConfig>(formParams));
        deviceForm.add(new RequiredTextField<String>(SerialPortDeviceConfig.KEY_SERIAL_PORT_ID,
                String.class).add(new StringValidator(1, 50)));
        deviceForm.add(new RequiredTextField<Integer>(SerialPortDeviceConfig.KEY_SERIAL_PORT_SPEED,
                Integer.class).add(new RangeValidator<Integer>(0, 115200)));
        deviceForm.add(new RequiredTextField<String>(RegexSensorConfig.KEY_REGEX_PATTERN, String.class));

        add(deviceForm);

    }
}
