package myapp.webui;

import myapp.webui.sample1.DummyDevicePage;
import myapp.webui.sample2.GpioActuatorPage;
import myapp.webui.sample3.SerialDevicePage;
import myapp.webui.sample4.I2cDevicePage;

import org.apache.wicket.markup.html.link.Link;

import com.wabit.uecs.pi.webui.MenuPanel;

public class MyMenuPanel extends MenuPanel {


    public MyMenuPanel(String id) {
        super(id);
    }


    @Override
    protected void onInitialize() {
        super.onInitialize();
        add(new Link<String>("dummy") {
            private static final long serialVersionUID = 1L;
            @Override
            public void onClick() {
                setResponsePage(DummyDevicePage.class);
            }
        });
        add(new Link<String>("gpioTimer") {
            private static final long serialVersionUID = 1L;
            @Override
            public void onClick() {
                setResponsePage(GpioActuatorPage.class);
            }
        });
        add(new Link<String>("dummySerial") {
            private static final long serialVersionUID = 1L;
            @Override
            public void onClick() {
                setResponsePage(SerialDevicePage.class);
            }
        });
        add(new Link<String>("dummyI2c") {
            private static final long serialVersionUID = 1L;
            @Override
            public void onClick() {
                setResponsePage(I2cDevicePage.class);
            }
        });
    }

}
