package myapp.device.sample3;

import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import com.wabit.uecs.pi.device.PiSensorBase;

public class RegexSensor extends PiSensorBase<RegexSensorConfig> {
    private Pattern regexPattern;

    public RegexSensor(String id) {
        super(id, new RegexSensorConfig());
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();
        RegexSensorConfig conf = getConfig();
        String textPattern = conf.getString(RegexSensorConfig.KEY_REGEX_PATTERN);
        if (textPattern != null) {
            try {
                regexPattern = Pattern.compile(textPattern);
            } catch (PatternSyntaxException e) {
                notifyException(e);
            }
        }
    }

    @Override
    protected void onStart() throws Exception {
    }

    @Override
    protected void onStop() throws Exception {
    }

    public void parseData(byte[] data) {
        String text = null;
        try {
            text = new String(data, "us-ascii");
        } catch (UnsupportedEncodingException e) {
            return;
        }

        if (regexPattern != null && text != null) {
            Matcher matcher = regexPattern.matcher(text);
            if (matcher.find()) {
                String sval = matcher.group(1);
                try {
                    double value = Double.valueOf(sval);
                    setValue(value);
                } catch (NumberFormatException e) {
                    notifyException(e);
                }
            }
        }
    }
}
