package myapp.device.sample2;

import com.wabit.uecs.pi.device.gpio.DigitalSwitchActuatorConfig;


public class TimerSwitchActuatorConfig extends DigitalSwitchActuatorConfig {

    private static final long serialVersionUID = 1L;

    /** 設定項目キー : 定周期動作間隔 */
    public static final String KEY_PERIODIC_INTERVAL = "PeriodicInterval";
    /** 設定項目キー : ON動作間隔 */
    public static final String KEY_PERIODIC_ON = "PeriodicOn";
    /** 設定項目キー : 動作停止開始時刻(時) */
    public static final String KEY_PERIODIC_INACTIVE_START_HOUR = "PeriodicInactiveStartHour";
    /** 設定項目キー : 動作停止開始時刻(分) */
    public static final String KEY_PERIODIC_INACTIVE_START_MIN = "PeriodicInactiveStartMinute";
    /** 設定項目キー : 動作停止終了時刻(時) */
    public static final String KEY_PERIODIC_INACTIVE_END_HOUR = "PeriodicInactiveEndHour";
    /** 設定項目キー : 動作停止終了時刻(分) */
    public static final String KEY_PERIODIC_INACTIVE_END_MIN = "PeriodicInactiveEndMinute";

    public TimerSwitchActuatorConfig() {
        setInt(KEY_DEFAULT_VALUE, 0);
        setInt(KEY_FIXED_VALUE, 0);
        setBoolean(KEY_INVERSE, false);
        setBoolean(KEY_IS_REPRESENTATIVE, false);
        setInt(KEY_CCM_LINE, 1);
        setInt(KEY_GPIO_PIN_SW_OUT, 0);
        setString(KEY_COMPONENT_NAME, "Timer Switch");
        setString(KEY_CCM_INFO_NAME, "Switch");
    }
}
