/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.webui.top;

import java.util.Date;

import org.apache.wicket.util.io.IClusterable;

/**
 * アクチュエータ一覧の１行分情報クラスです。
 *
 * @author WaBit
 */
public class ActuatorRow implements IClusterable {

    private static final long serialVersionUID = 8397901097987027968L;
    private String name;
    private String mode;
    private String value;
    private Date updateTime;

    /**
     * 表示名称を取得します。
     * @return 名称
     */
    public String getName() {
        return name;
    }

    /**
     * 表示名称を設定します。
     * @param name 名称
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 動作モードを取得します。
     * @return 動作モード
     */
    public String getMode() {
        return mode;
    }

    /**
     * 動作モードを設定します。
     * @param mode 動作モード
     */
    public void setMode(String mode) {
        this.mode = mode;
    }

    /**
     * 更新日時を取得します。
     * @return 時刻
     */
    public Date getUpdateTime() {
        return updateTime;
    }

    /**
     * 更新日時を設定します。
     * @param updateTime 時刻
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 現在値を取得します。
     * @return 現在値
     */
    public String getValue() {
        return value;
    }

    /**
     * 現在値を設定します。
     * @param value 現在値
     */
    public void setValue(String value) {
        this.value = value;
    }

}
