/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.webui;

import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.panel.Panel;

import com.wabit.uecs.pi.webui.ccmlist.CcmListPage;
import com.wabit.uecs.pi.webui.log.LogPage;
import com.wabit.uecs.pi.webui.nodeconfig.NodeConfigPage;

/**
 * メニュー部分を表示するパネルクラスです。
 *
 * @author WaBit
 */
public class MenuPanel extends Panel {

    private static final long serialVersionUID = -3091806330060682156L;

    /**
     * コンストラクタです。
     * @param id ID
     */
    public MenuPanel(String id) {
        super(id);
    }


    @Override
    protected void onInitialize() {
        super.onInitialize();
        add(new Link<String>("top") {
            private static final long serialVersionUID = 1L;
            @Override
            public void onClick() {
                setResponsePage(getApplication().getHomePage());
            }
        });
        add(new Link<String>("nodeConfig") {
            private static final long serialVersionUID = 1L;
            @Override
            public void onClick() {
                setResponsePage(NodeConfigPage.class);
            }
        });
        add(new Link<String>("ccmList") {
            private static final long serialVersionUID = 1L;
            @Override
            public void onClick() {
                setResponsePage(CcmListPage.class);
            }
        });
        add(new Link<String>("statusLog") {
            private static final long serialVersionUID = 1L;
            @Override
            public void onClick() {
                setResponsePage(LogPage.class);
            }
        });
        add(new Link<String>("logOut") {
            private static final long serialVersionUID = 1L;
            @Override
            public void onClick() {
                AuthenticatedWebSession.get().invalidate();
                setResponsePage(getApplication().getHomePage());
            }
        });

    }

}
