package com.wabit.uecs.pi.device.gpio;

import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinAnalogInput;
import com.pi4j.io.gpio.GpioPinAnalogOutput;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.GpioPinInput;
import com.pi4j.io.gpio.GpioPinOutput;
import com.pi4j.io.gpio.GpioPinPwmOutput;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.wabit.uecs.pi.device.PiDeviceBase;

public abstract class GpioDeviceBase<T extends GpioDeviceConfig> extends PiDeviceBase<T> {


    protected GpioDeviceBase(String deviceId, T config) {
        super(deviceId, config);
    }

    /*
     * (非 Javadoc)
     * @see com.wabit.uecs.pi.device.PiDeviceBase#onInit()
     */
    @Override
    protected void onInit() throws Exception {
        super.onInit();
    }

    /**
     * 制御対象のPI4JのGPIOピンインスタンスを取得します。
     * @param pin ピン
     * @return GpioPinインスタンス
     */
    public abstract GpioPinInput getProvisionedGpioPinInput(Pin pin);

    /**
     * 制御対象のPI4JのGPIOピンインスタンスを取得します。
     * @param pin ピン
     * @return GpioPinインスタンス
     */
    public abstract GpioPinOutput getProvisionedGpioPinOutput(Pin pin);

    /**
     * 新規デジタル入力ピンを設定します。
     * @param pin
     * @param registance
     * @return 入力ピンインスタンス
     */
    public abstract GpioPinDigitalInput provisionDigitalInputPin(Pin pin, PinPullResistance registance);

    /**
     * 新規デジタル出力ピンを設定します。
     * @param pin
     * @param state
     * @return 出力ピンインスタンス
     */
    public abstract GpioPinDigitalOutput provisionDigitalOutputPin(Pin pin, PinState state);

    /**
     * 新規アナログ入力ピンを設定します。
     * @param pin
     * @param registance
     * @return 入力ピンインスタンス
     */
    public abstract GpioPinAnalogInput provisionAnalogInputPin(Pin pin);

    /**
     * 新規アナログ出力ピンを設定します。
     * @param pin
     * @param state
     * @return 出力ピンインスタンス
     */
    public abstract GpioPinAnalogOutput provisionAnalogOutputPin(Pin pin);

    /**
     * 新規PWM出力ピンを設定します。
     * @param pin
     * @param state
     * @return 出力ピンインスタンス
     */
    public abstract GpioPinPwmOutput provisionPwmOutputPin(Pin pin);

    /**
     * PI4Jのピンインスタンスを取得します。
     * @param pinName ピン名称
     * @return Pinインスタンス
     */
    public abstract Pin getPin(String pinName);

    /**
     * ピンリスナーを追加します。
     * @param listener
     * @param pin
     */
    public abstract void addListener(GpioPinListener listener, GpioPinInput pin);

    /**
     * ピンリスナーを削除します。
     * @param listener
     * @param pin
     */
    public abstract void removeListener(GpioPinListener listener, GpioPinInput pin);

    /**
     * ピンを制御対象から外します。
     * @param paramVarArgs
     */
    public abstract void unprovisionPin(GpioPin... paramVarArgs);
}
