/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.db;

import java.io.Serializable;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;

/**
 * デバイス定義のDBエンティティです。
 *
 * @author WaBit
 */
@DatabaseTable(tableName = "device")
public class DeviceEntity implements Serializable {

    private static final long serialVersionUID = -2057886231998113844L;
    /** カラム名:デバイスID */
    public static final String DEVICE_ID = "dev_id";
    /** カラム名:デバイスクラス */
    public static final String DEVICE_NAME = "dev_name";
    /** カラム名:デバイスクラス */
    public static final String DEVICE_CLASS = "dev_class";

    @DatabaseField(columnName = DEVICE_ID, id = true, allowGeneratedIdInsert=false)
    private String id;

    @DatabaseField(columnName = DEVICE_NAME, canBeNull = false)
    private String devName;

    @DatabaseField(columnName = DEVICE_CLASS, canBeNull = false)
    private String clazz;

    /**
     * デバイスIDを取得します。
     * @return デバイスID
     */
    public String getDeviceId() {
        return id;
    }

    /**
     * デバイスIDを設定します。
     * @param id デバイスID
     */
    public void setDeviceId(String id) {
        this.id = id;
    }

    /**
     * デバイス名称を取得します。
     * @return デバイス名称
     */
    public String getDeviceName() {
        return devName;
    }

    /**
     * デバイス名称を設定します。
     * @param devName デバイス名称
     */
    public void setDeviceName(String devName) {
        this.devName = devName;
    }

    /**
     * デバイスクラスを取得します。
     * @return クラス名
     */
    public String getDeviceClass() {
    	return this.clazz;
    }

    /**
     * デバイスクラスを設定します。
     * @param clazz クラス名
     */
    public void setDeviceClass(String clazz) {
    	this.clazz = clazz;
    }

}
