/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.webui.nodeconfig;

import java.util.Date;

import org.apache.wicket.util.io.IClusterable;

/**
 * ノード設定フォーム情報を保持するクラスです。
 *
 * @author WaBit
 */
public class NodeSetting implements IClusterable {

    private static final long serialVersionUID = 6874100067259146143L;

    private String nodeName;

    private String nodeType;

    private String ipType;

    private String ipAddress;

    private String ipMask;

    private String gateway;

    private String dnsServer;

    private Date currentDate;

    private boolean isChangeCurrentDate;

    private String password;

    private Integer room;

    private Integer region;

    private Integer order;

    private Integer priority;

    private boolean isRcvDateTime;

    private boolean isSndDateTime;

    private String locale;

    private String timeZone;

    /**
     * ノード名称を取得します。
     * @return ノード名称
     */
    public String getNodeName() {
        return nodeName;
    }

    /**
     * ノード名称を設定します。
     * @param nodeName ノード名称
     */
    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    /**
     * IP種別を取得します。
     * @return IP種別
     */
    public String getIpType() {
        return ipType;
    }

    /**
     * IP種別を設定します。
     * @param ipType IP種別
     */
    public void setIpType(String ipType) {
        this.ipType = ipType;
    }

    /**
     * IPアドレスを取得します。
     * @return IPアドレス
     */
    public String getIpAddress() {
        return ipAddress;
    }

    /**
     * IPアドレスを設定します。
     * @param ipAddress IPアドレス
     */
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    /**
     * サブネットマスクを取得します。
     * @return サブネットマスク
     */
    public String getIpMask() {
        return ipMask;
    }

    /**
     * サブネットマスクを設定します。
     * @param ipMask サブネットマスク
     */
    public void setIpMask(String ipMask) {
        this.ipMask = ipMask;
    }

    /**
     * デフォルトゲートウェイアドレスを取得します。
     * @return IPアドレス
     */
    public String getGateway() {
        return gateway;
    }

    /**
     * デフォルトゲートウェイアドレスを設定します。
     * @param gateway IPアドレス
     */
    public void setGateway(String gateway) {
        this.gateway = gateway;
    }

    /**
     * DNSサーバアドレスを取得します。
     * @return IPアドレス
     */
    public String getDnsServer() {
        return dnsServer;
    }

    /**
     * DNSサーバアドレスを設定します。
     * @param dnsServer IPアドレス
     */
    public void setDnsServer(String dnsServer) {
        this.dnsServer = dnsServer;
    }

    /**
     * 現在時刻を取得します。
     * @return 時刻
     */
    public Date getCurrentDate() {
        return currentDate;
    }

    /**
     * 現在時刻を設定します。
     * @param currentDate 時刻
     */
    public void setCurrentDate(Date currentDate) {
        this.currentDate = currentDate;
    }

    /**
     * 時刻変更フラグを取得します。
     * @return フラグ
     */
    public boolean getIsChangeCurrentDate() {
        return isChangeCurrentDate;
    }

    /**
     * 時刻変更フラグを設定します。
     * @param isChangeCurrentDate フラグ
     */
    public void setIsChangeCurrentDate(boolean isChangeCurrentDate) {
        this.isChangeCurrentDate = isChangeCurrentDate;
    }

    /**
     * 管理パスワードを取得します。
     * @return パスワード
     */
    public String getPassword() {
        return password;
    }

    /**
     * 管理パスワードを設定します。
     * @param password パスワード
     */
    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * room値を取得します。
     * @return room
     */
    public Integer getRoom() {
        return room;
    }

    /**
     * room値を設定します。
     * @param room
     */
    public void setRoom(Integer room) {
        this.room = room;
    }

    /**
     * region値を取得します。
     * @return region
     */
    public Integer getRegion() {
        return region;
    }

    /**
     * region値を設定します。
     * @param region
     */
    public void setRegion(Integer region) {
        this.region = region;
    }

    /**
     * order値を取得します。
     * @return order
     */
    public Integer getOrder() {
        return order;
    }

    /**
     * order値を設定します。
     * @param order
     */
    public void setOrder(Integer order) {
        this.order = order;
    }

    /**
     * priority値を取得します。
     * @return priority
     */
    public Integer getPriority() {
        return priority;
    }

    /**
     * priority値を設定します。
     * @param priority
     */
    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    /**
     * Date/Time CCM受信フラグを取得します。
     * @return フラグ
     */
    public boolean getIsRcvDateTime() {
        return isRcvDateTime;
    }

    /**
     *  Date/Time CCM受信フラグを設定します。
     * @param isRcvDateTime フラグ
     */
    public void setIsRcvDateTime(boolean isRcvDateTime) {
        this.isRcvDateTime = isRcvDateTime;
    }

    /**
     * ノード種別を取得します。
     * @return ノード種別(kNN)
     */
    public String getNodeType() {
        return nodeType;
    }

    /**
     * ノード種別を設定します。
     * @param nodeType ノード種別(kNN)
     */
    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    /**
     * タイムゾーンを取得します。
     * @return タイムゾーンID
     */
    public String getTimeZone() {
        return timeZone;
    }

    /**
     * タイムゾーンを設定します。
     * @param timeZone タイムゾーンID
     */
    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    /**
     * ロケールを取得します。
     * @return ロケールID
     */
    public String getLocale() {
        return locale;
    }

    /**
     * ロケールを設定します。。
     * @param locale ロケールID
     */
    public void setLocale(String locale) {
        this.locale = locale;
    }

    /**
     * Date/Time CCM送信フラグを取得します。
     * @return フラグ
     */
    public boolean getIsSndDateTime() {
        return isSndDateTime;
    }

    /**
     * Date/Time CCM送信フラグを設定します。
     * @param isSndDateTime フラグ
     */
    public void setIsSndDateTime(boolean isSndDateTime) {
        this.isSndDateTime = isSndDateTime;
    }

}