/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.webui.ccmlist;

import java.util.Date;

import org.apache.wicket.util.io.IClusterable;

/**
 * CCM一覧の一行分データを保持するクラスです。
 *
 * @author WaBit
 *
 */
public class CcmRow implements IClusterable {

    private static final long serialVersionUID = -9220804686495390895L;
    private String name;
    private String type;
    private String level;
    private int room;
    private int region;
    private int order;
    private String value;
    private String unit;
    private String side;
    private Date updateTime;
    private String expired;

    /**
     * CCM名称を取得します。
     * @return CCM名称
     */
    public String getName() {
        return name;
    }

    /**
     * CCM名称を設定します。
     * @param name CCM名称
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * CCM識別子を取得します。
     * @return CCM識別子
     */
    public String getType() {
        return type;
    }

    /**
     * CCM識別子を設定します。
     * @param type CCM識別子
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * 送受信レベルを取得します。
     * @return レベル表記
     */
    public String getLevel() {
        return level;
    }

    /**
     * 送受信レベルを設定します。
     * @param level レベル表記
     */
    public void setLevel(String level) {
        this.level = level;
    }

    /**
     * roomを取得します。
     * @return room
     */
    public int getRoom() {
        return room;
    }

    /**
     * roomを設定します。
     * @param room
     */
    public void setRoom(int room) {
        this.room = room;
    }

    /**
     * regionを取得します。
     * @return region
     */
    public int getRegion() {
        return region;
    }

    /**
     * regionを設定します。
     * @param region
     */
    public void setRegion(int region) {
        this.region = region;
    }

    /**
     * orderを取得します。
     * @return order
     */
    public int getOrder() {
        return order;
    }

    /**
     * orderを設定します。
     * @param oreder
     */
    public void setOrder(int oreder) {
        this.order = oreder;
    }

    /**
     * CCM値を取得します。
     * @return CCM値
     */
    public String getValue() {
        return value;
    }

    /**
     * CCM値を設定します。
     * @param value CCM値
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * 単位を取得します。
     * @return 単位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 単位を設定します。
     * @param unit 単位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }

    /**
     * 送受信方向を取得します。
     * @return 方向(R/S)
     */
    public String getSide() {
        return side;
    }

    /**
     * 送受信方向を設定します。
     * @param side 方向(R/S)
     */
    public void setSide(String side) {
        this.side = side;
    }

    /**
     * 更新日時を取得します。
     * @return 更新日時
     */
    public Date getUpdateTime() {
        return updateTime;
    }

    /**
     * 更新日時を設定します。
     * @param updateTime 更新日時
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 期限切れ記号を取得します。
     * @return 期限切れ記号
     */
    public String getExpired() {
        return expired;
    }

    /**
     * 期限切れ記号を設定します。
     * @param expired 期限切れ記号
     */
    public void setExpired(String expired) {
        this.expired = expired;
    }

}
