/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.webui;

import java.util.ArrayList;

import org.apache.wicket.markup.html.form.ChoiceRenderer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.joda.time.DateTimeZone;

/**
 * タイムゾーン選択用共通パーツです。
 *
 * @author WaBit
 *
 */
public class TimeZoneChoice extends DropDownChoice<String> {


    /**
     * タイムゾーン選択リストを生成します。
     * @param id 画面コンポーネントID
     */
    public TimeZoneChoice(String id) {
        super(id);
        setChoiceRenderer(new ChoiceRenderer<String>(){
            @Override
            public Object getDisplayValue(String id) {
                DateTimeZone tz = DateTimeZone.forID(id);
                return tz.toTimeZone().getDisplayName() + "[" + tz.getShortName(0) + "]";
            }

        });

        setChoices(new ArrayList<String>(DateTimeZone.getAvailableIDs()));
    }


}
