/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.webui;

import java.util.Arrays;

import org.apache.wicket.markup.html.form.DropDownChoice;

import com.wabit.uecs.pi.device.PiSensorConfig;

/**
 * センサー検出方式選択用共通パーツです。
 *
 * @author WaBit
 *
 */
public class DetectionMethodChoice extends DropDownChoice<String> {
    private static String[] detectionMethods = new String[] {
        PiSensorConfig.DETECTION_MOMENT, PiSensorConfig.DETECTION_SMA, PiSensorConfig.DETECTION_WMA
    };

    /**
     * 検出方式を内部リストに持ったChoiceを生成します。
     * @param id 画面コンポーネントID
     */
    public DetectionMethodChoice(String id) {
        super(id, Arrays.asList(detectionMethods));
        setRequired(true);
        setNullValid(false);
    }

    @Override
    protected boolean localizeDisplayValues() {
        return true;
    }

}
