/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.util;

import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 日時を扱うユーティリティメソッドを提供します。
 *
 * @author WaBit
 */
public class DateTimeUtils {

    /** フォーマット： "yyyy-MM-dd HH:mm:ss"*/
    public static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    /** フォーマット： "yyyy-MM-dd"*/
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    /** フォーマット： "HH:mm:ss"*/
    public static final String TIME_FORMAT = "HH:mm:ss";

    // 隠ぺい
    private DateTimeUtils() {

    }

    /**
     * 日時フォーマット文字を返します。
     * @param date 日時
     * @return フォーマット後文字列
     */
    public static final String toDateTimeString(Date date) {
        SimpleDateFormat dft = new SimpleDateFormat(DATETIME_FORMAT);
        return dft.format(date);
    }

    /**
     * 日付フォーマット文字を返します。
     * @param date 日時
     * @return フォーマット後文字列
     */
    public static final String toDateString(Date date) {
        SimpleDateFormat dft = new SimpleDateFormat(DATE_FORMAT);
        return dft.format(date);
    }

    /**
     * 時刻フォーマット文字を返します。
     * @param date 日時
     * @return フォーマット後文字列
     */
    public static final String toTimeString(Date date) {
        SimpleDateFormat dft = new SimpleDateFormat(TIME_FORMAT);
        return dft.format(date);
    }

    /**
     * フォーマット文字を指定して返します。
     * @param date 日時
     * @return フォーマット後文字列
     */
    public static final String toFormatString(Date date, String format) {
        SimpleDateFormat dft = new SimpleDateFormat(format);
        return dft.format(date);
    }

}
