/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.device.i2c;

import com.pi4j.io.i2c.I2CBus;
import com.wabit.uecs.pi.device.PiDeviceConfig;
import com.wabit.uecs.pi.webui.WebUIApplication;

/**
 * I2C接続デバイスの設定値クラスです。
 *
 * @author WaBit
 */
public class I2cDeviceConfig extends PiDeviceConfig {

    private static final long serialVersionUID = -9163314176407323242L;

    /** 設定項目キー : I2C通信クライアントクラス */
    public static final String KEY_I2C_CLIENT_CLASS = "I2cClientClass";
    /** 設定項目キー : I2Cバス番号 */
    public static final String KEY_I2C_BUS = "I2cBus";
    /** 設定項目キー : I2Cアドレス */
    public static final String KEY_I2C_ADDRESS = "I2cAddress";
    /** 設定項目キー : センサー値取得動作間隔(sec) */
    public static final String KEY_SENSE_INTERVAL = "SenseInterval";

    public I2cDeviceConfig() {
        setInt(KEY_I2C_BUS, I2CBus.BUS_1);
        // 動作モードで接続方式を変更
        if (WebUIApplication.getNodeInstance().isDevelopmentMode()) {
            // 開発モードの場合はモック実装を利用
            setString(KEY_I2C_CLIENT_CLASS, PiI2CDeviceMockImpl.class.getName());
        } else {
            // デプロイモードの場合はPi4JのI2C接続実装
            setString(KEY_I2C_CLIENT_CLASS, com.pi4j.io.i2c.impl.I2CDeviceImpl.class.getName());
        }
    }

}
