/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.device.gpio;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import com.pi4j.io.gpio.event.PinEventType;
import com.wabit.uecs.device.actuator.ActuatorComponent;
import com.wabit.uecs.device.actuator.IActuatorAction;

/**
 * スイッチアクチュエータのインターロック動作実装です。
 *
 * @author WaBit
 *
 */
public class DigitalSwitchInterlockAction implements IActuatorAction, GpioPinListenerDigital {

    private DigitalSwitchActuator<?> switchActuator;
    // ロガー
    private Log logger = LogFactory.getLog(getClass());


    /**
     * 入力ピンの状態を見て連動させます。
     */
    @Override
    public synchronized void execute(ActuatorComponent<?> paramActuatorComponent) throws Exception {
        GpioPinDigitalInput inputPin = switchActuator.getGpioInputPin();
        if (inputPin.getState().isLow()) {
            switchActuator.on();
        } else {
            switchActuator.off();
        }
    }

    /*
     * (非 Javadoc)
     * @see com.wabit.uecs.device.actuator.IActuatorAction#onStart(com.wabit.uecs.device.actuator.ActuatorComponent)
     */
    @Override
    public void onStart(ActuatorComponent<?> paramActuatorComponent) throws Exception {
        if (!(paramActuatorComponent instanceof DigitalSwitchActuator)) {
            throw new IllegalArgumentException("invalid actuator = " + paramActuatorComponent.getClass().getName());
        }
        switchActuator = (DigitalSwitchActuator<?>)paramActuatorComponent;
        GpioDeviceBase<?> device = (GpioDeviceBase<?>) switchActuator.getDevice();
        device.addListener(this, switchActuator.getGpioInputPin());
        // 初期状態セット
        execute(paramActuatorComponent);
    }

    /*
     * (非 Javadoc)
     * @see com.wabit.uecs.device.actuator.IActuatorAction#onStop(com.wabit.uecs.device.actuator.ActuatorComponent)
     */
    @Override
    public void onStop(ActuatorComponent<?> paramActuatorComponent) throws Exception {
        GpioDeviceBase<?> device = (GpioDeviceBase<?>) switchActuator.getDevice();
        device.removeListener(this, switchActuator.getGpioInputPin());
    }

    /**
     * ピン状態変更イベント処理を行います。
     */
    @Override
    public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
        if (event.getEventType() == PinEventType.DIGITAL_STATE_CHANGE) {
            try {
                execute(switchActuator);
            } catch (Exception e) {
                logger.error("process faild.", e);
            }
        }
    }
}
