/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.db;

import java.io.Serializable;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;

/**
 * デバイス設定のDBエンティティです。
 *
 * @author WaBit
 */
@DatabaseTable(tableName = "device_config")
public class DeviceConfigEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    /** カラム名: ID(デバイスID.プロパティキー値) */
    public static final String PROP_ID = "prop_id";

    /** カラム名: デバイスID */
    public static final String DEVICE_ID = "dev_id";

    /** カラム名:プロパティキー名 */
    public static final String KEY = "key";

    /** カラム名:プロパティ値 */
    public static final String VALUE = "value";

    @DatabaseField(columnName = PROP_ID, id = true, allowGeneratedIdInsert=false)
    private String id;

    @DatabaseField(columnName = DEVICE_ID, index = true)
    private String deviceId;


    @DatabaseField(columnName = KEY, canBeNull = false)
    private String key;

    @DatabaseField(columnName = VALUE, canBeNull = true)
    private String value;

    /**
     * レコードIDを取得します。
     * @return レコードID
     */
    public String getId() {
        return id;
    }

    /**
     * レコードIDを設定します。
     * @param id レコードID
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * デバイスIDを取得します。
     * @return デバイスID
     */
    public String getDeviceId() {
        return deviceId;
    }

    /**
     * デバイスIDを設定します。
     * @param deviceId デバイスID
     */
    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    /**
     * 設定値キーを取得します
     * @return キー文字列
     */
    public String getKey() {
        return key;
    }

    /**
     * 設定値キーを設定します。
     * @param key キー文字列
     */
    public void setKey(String key) {
        this.key = key;
    }

    /**
     * 設定値を取得します。
     * @return 設定値
     */
    public String getValue() {
        return value;
    }

    /**
     * 設定値を設定します。
     * @param value 設定値。
     */
    public void setValue(String value) {
        this.value = value;
    }


}
