/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.db;

import java.io.Serializable;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;

/**
 * コンポーネントデータ値のDBエンティティです。
 *
 * @author WaBit
 */
@DatabaseTable(tableName = "compo_data")
public class ComponentValueEntity implements Serializable {

    private static final long serialVersionUID = 4054245888388736720L;

    /** カラム名: レコードNo */
    public static final String REC_NO = "rec_no";
    /** カラム名: コンポーネントID */
    public static final String COMPONENT_ID = "compo_id";
    /** カラム名: 記録日時 */
    public static final String TIME = "time";
    /** カラム名: データ値 */
    public static final String VALUE = "value";

    @DatabaseField(columnName=REC_NO, id = true, allowGeneratedIdInsert = false)
    private Long recNo;
    @DatabaseField(columnName=COMPONENT_ID, index = true)
    private String componentId;
    @DatabaseField(columnName=TIME, index = true)
    private Long time;
    @DatabaseField(columnName=VALUE)
    private Double value;

    /**
     * レコードNoを取得します。
     * @return レコードNo
     */
    public Long getRecNo() {
        return recNo;
    }

    /**
     * レコードNoを設定します。
     * @param recNo レコードNo
     */
    public void setRecNo(Long recNo) {
        this.recNo = recNo;
    }

    /**
     * 記録日時を取得します。
     * @return 記録日時（システム時刻msec）
     */
    public Long getTime() {
        return time;
    }

    /**
     * 記録日時を設定します。
     * @param time 記録日時（システム時刻msec）
     */
    public void setTime(Long time) {
        this.time = time;
    }

    /**
     * データ値を取得します。
     * @return データ値
     */
    public Double getValue() {
        return value;
    }

    /**
     * データ値を設定します。
     * @param value データ値
     */
    public void setValue(Double value) {
        this.value = value;
    }

    /**
     * コンポーネントIDを取得します。
     * @return コンポーネントID
     */
    public String getComponentId() {
        return componentId;
    }

    /**
     * コンポーネントIDを設定します。
     * @param componentId コンポーネントID
     */
    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

}
