/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi;

/**
 * アプリケーション共通定数クラスです。
 *
 * @author WaBit
 *
 */
public class AppConstants {
    /** セッションキー: 認証情報 */
    public static final String SESSION_KEY_AUTH = "uecs_node_auth";

    /** データベースファイル作成パス */
    public static final String DATABASE_PATH = "/WEB-INF/db/UecsNode.db";

    /** 動作モード */
    public static final String APP_MODE_KEY = "appMode";

    /** ノードIPアドレスの取得タイプ：DHCP */
    public static final String IP_TYPE_DHCP = "dhcp";

    /** ノードIPアドレスの取得タイプ：固定IP */
    public static final String IP_TYPE_STATIC = "static";

    /** 機器状態異常値：重度障害 デバイス異常  */
    public static final int STATUS_ARERT_DEVICE_ERROR = 0xC000000;
    /** 機器状態異常値：軽度障害 DateTime受信待ち */
    public static final int STATUS_ATTENTION_DATETIME = 0x200000;

    /** 実行スクリプトパス：システム時刻変更 */
    public static final String SCRIPT_CHANGE_DATETIME = "/opt/scripts/change_current_date.sh";
    /** 実行スクリプトパス：固定IPアドレス変更 */
    public static final String SCRIPT_CHANGE_IP_STATIC = "/opt/scripts/change_ip_static.sh";
    /** 実行スクリプトパス：デフォルトゲートウェイアドレス変更 */
    public static final String SCRIPT_CHANGE_IP_GW = "/opt/scripts/change_ip_gateway.sh";
    /** 実行スクリプトパス：DHCPアドレス変更 */
    public static final String SCRIPT_CHANGE_IP_DHCP = "/opt/scripts/change_ip_dhcp.sh";
    /** 実行スクリプトパス：DNSサーバ変更 */
    public static final String SCRIPT_SET_DNS = "/opt/scripts/set_dnsserver.sh";
    /** 実行スクリプト：OSシャットダウン */
    public static final String SCRIPT_OS_SHUTDOWN = "/sbin/shutdown -h now";
    /** 実行スクリプト：OS再起動 */
    public static final String SCRIPT_OS_REBOOT = "/sbin/reboot";
    /** ログ保持数 */
    public static final int MAX_LOG_NUM = 1000;

    /** データ保存数 */
    public static final int MAX_DATA_NUM = 100000;

    /** ボード種別 */
    public static final String RASPI_MODEL_B = "Model B";
    public static final String RASPI_MODEL_B_PLUS = "Model B+";
    public static final String RASPI_2_MODEL_B = "2 Model B";

    private AppConstants() {
    }

}
