/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.webui.top;

import java.util.Date;

import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.datetime.markup.html.basic.DateLabel;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.StatelessForm;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;

import com.wabit.uecs.UecsConstants;
import com.wabit.uecs.device.IComponent;
import com.wabit.uecs.device.IDevice;
import com.wabit.uecs.device.actuator.ActuatorComponent;
import com.wabit.uecs.device.controller.ControllerComponent;
import com.wabit.uecs.device.sensor.SensorComponent;
import com.wabit.uecs.pi.UecsPiNode;
import com.wabit.uecs.pi.webui.LayoutPage;
import com.wabit.uecs.pi.webui.WebUIApplication;

/**
 * WebUIのトップ画面機能を実装したクラスです。
 *
 * @author WaBit
 */
@AuthorizeInstantiation({Roles.ADMIN})
public class TopPage extends LayoutPage {
    /** 表示メッセージキー： 正常 */
    private static final String ITEM_STATUS_NORMAL = "item.statusNormal";
    /** 表示メッセージキー： 軽度異常 */
    private static final String ITEM_STATUS_ATTENTION = "item.statusAttention";
    /** 表示メッセージキー： 重度異常 */
    private static final String ITEM_STATUS_ALERT = "item.statusAlert";
    /** 表示メッセージキー： 停止 */
    private static final String ITEM_STATUS_STOPPED = "item.statusStopped";
    /** 表示メッセージキー： 日時初期化待ち */
    private static final String ITEM_STATUS_DATETIME = "item.statusDatetime";


    private static final long serialVersionUID = 2987526883703489279L;


    @Override
    protected void onInitialize() {
        super.onInitialize();

        StatelessForm<TopPage> form = new StatelessForm<TopPage>("form") {
            private static final long serialVersionUID = 1L;

            @Override
            protected void onSubmit() {
                setResponsePage(TopPage.this.getClass());
            }
        };

        add(form);

        form.setDefaultModel(new CompoundPropertyModel<TopPage>(this));

        UecsPiNode node = WebUIApplication.getNodeInstance();

        add(new Label("ipAddress",node.getIpAddress().toString().replace("/", "")));
        add(DateLabel.forDatePattern("currentDate", Model.of(new Date()), "yyyy-MM-dd HH:mm:ss z"));

        // ノードステータス表示
        ResourceModel status;
        if (node.isActive()) {
            int st = node.getStatus();
            if ((st & UecsConstants.STATUS_AREA_ALERT) > 0) {
                status = new ResourceModel(ITEM_STATUS_ALERT);
            } else if ((st & UecsConstants.STATUS_AREA_ATTENTION) > 0) {
                if ((st & UecsConstants.STATUS_AREA_ATTENTION) > 0) {
                    status = new ResourceModel(ITEM_STATUS_DATETIME);
                } else {
                    status = new ResourceModel(ITEM_STATUS_ATTENTION);
                }
            } else {
                status = new ResourceModel(ITEM_STATUS_NORMAL);
            }
        } else {
            status = new ResourceModel(ITEM_STATUS_STOPPED);
        }
        add(new Label("status", status));

        boolean sensorEnabled = false;
        boolean actuatorEnabled = false;
        boolean controllerEnabled = false;
        for (IDevice<?> device : node.listDevices()) {
            for (IComponent<?> compo : device.listComponents()) {
                if (compo instanceof SensorComponent) {
                    sensorEnabled = true;
                }
                if (compo instanceof ActuatorComponent) {
                    actuatorEnabled = true;
                }
                if (compo instanceof ControllerComponent) {
                    controllerEnabled = true;
                }
                // 無駄ループを省くための判定
                if (sensorEnabled && actuatorEnabled && controllerEnabled) {
                    break;
                }
            }
        }
        if (sensorEnabled) {
            add(new SensorsPanel("sensorList"));
        } else {
            add(new Label("sensorList"));
        }
        if (actuatorEnabled) {
            add(new ActuatorsPanel("actuatorList"));
        } else {
            add(new Label("actuatorList"));
        }
        if (controllerEnabled) {
            add(new ControllersPanel("controllerList"));
        } else {
            add(new Label("controllerList"));
        }

    }
}
