/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.webui.top;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.apache.wicket.datetime.markup.html.basic.DateLabel;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.Model;

import com.wabit.uecs.CcmService;
import com.wabit.uecs.device.ComponentConfig;
import com.wabit.uecs.device.IDevice;
import com.wabit.uecs.device.sensor.SensorComponent;
import com.wabit.uecs.pi.webui.WebUIApplication;

/**
 * センサー情報一覧の表示用パネルです。
 */
public class SensorsPanel extends Panel {
    private static final long serialVersionUID = -3708813079941308934L;

    public SensorsPanel(String id) {
        super(id);
        setRenderBodyOnly(true);

        List<SensorRow> sensorList = new ArrayList<SensorRow>();
        for (IDevice<?> device : WebUIApplication.getNodeInstance().listDevices()) {
            for (SensorComponent<?> sensor : device.listComponents(SensorComponent.class)) {
                SensorRow row = new SensorRow();
                row.setName(sensor.getConfig().getString(ComponentConfig.KEY_COMPONENT_NAME));
                row.setUnit(sensor.getConfig().getString(ComponentConfig.KEY_CCM_UNIT));
                CcmService ccmService = sensor.getCcmService();
                if (ccmService != null && ccmService.isEnable() && ccmService.getUpdateTime() > 0) {
                    if (!ccmService.isExpired() && ccmService.getCcm().getNumberValue() != null) {
                        row.setValue(ccmService.getCcm().getStringValue());
                    } else {
                        row.setValue("--");
                    }
                    row.setUpdateTime(new Date(sensor.getCcmService().getUpdateTime()));
                }
                sensorList.add(row);
            }
        }

        add(new ListView<SensorRow>("componentList", sensorList) {
            private static final long serialVersionUID = 1L;

            @Override
            protected void populateItem(ListItem<SensorRow> item) {
                item.add(new Label("idx", item.getIndex() + 1));
                item.add(new Label("name", item.getModelObject().getName()));
                if (item.getModelObject().getValue() != null) {
                    item.add(new Label("value", item.getModelObject().getValue()));
                } else {
                    item.add(new Label("value", "--"));
                }
                item.add(new Label("unit", item.getModelObject().getUnit()));
                if (item.getModelObject().getUpdateTime() != null) {
                    item.add(DateLabel.forDatePattern("updateTime", Model.of(item.getModelObject().getUpdateTime()),
                        "yyyy-MM-dd HH:mm:ss"));
                } else {
                    item.add(new Label("updateTime", "--"));
                }
            }
        });
    }

}
