/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.webui.top;

import java.util.Date;

import org.apache.wicket.util.io.IClusterable;

/**
 * センサー一覧の１行分情報クラスです。
 *
 * @author WaBit
 */
public class SensorRow implements IClusterable {

    private static final long serialVersionUID = 451486624545754645L;
    private String name;
    private String value;
    private String unit;
    private Date updateTime;

    /**
     * 表示名称を取得します。
     * @return 名称
     */
    public String getName() {
        return name;
    }

    /**
     * 表示名称を設定します。
     * @param name 名称
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * 更新日時を取得します。
     * @return 時刻
     */
    public Date getUpdateTime() {
        return updateTime;
    }

    /**
     * 更新日時を設定します。
     * @param updateTime 時刻
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 現在値を取得します。
     * @return 現在値
     */
    public String getValue() {
        return value;
    }

    /**
     * 現在値を設定します。
     * @param value 現在値
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * 単位を取得します。
     * @return 単位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 単位を設定します。
     * @param unit 単位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }

}
