/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.webui;

import org.apache.wicket.validation.validator.PatternValidator;

/**
 * 実数値フィールドバリデータです。
 * String型の入力フィールドとして、数値形式文字であるかをチェックします。
 * 通常のクラス型チェックでは、表示時に小数点以下の桁表示がE表記に変換されるなど不都合が
 * あるため、String型のままパターンチェックを行うために利用します。
 *
 * @author WaBit
 *
 */
public class RealNumberValidator extends PatternValidator {

    private static final String PATTERN = "[0-9.\\-\\+]*";

    /**
     * コンストラクタ
     */
    public RealNumberValidator() {
        super(PATTERN);
    }

}
