/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.webui;

import org.apache.wicket.feedback.FeedbackMessage;
import org.apache.wicket.feedback.IFeedbackMessageFilter;
import org.apache.wicket.markup.html.panel.FeedbackPanel;

/**
 * カスタマイズされたFeedbackPanelの実装クラスです。
 *
 * @author WaBit
 *
 */
public class CustomFeedbackPanel extends FeedbackPanel {

    private static final long serialVersionUID = 5571262750336514879L;

    /**
     * コンストラクタです。
     * @param id ID
     */
    public CustomFeedbackPanel(String id) {
        super(id);
    }

    /**
     * コンストラクタです。
     * @param id ID
     * @param filter メッセージフィルタ
     */
    public CustomFeedbackPanel(String id, IFeedbackMessageFilter filter) {
        super(id, filter);
    }

    /**
     * メッセージのレベルに応じたCSS定義を返します。
     */
    @Override
    protected String getCSSClass(FeedbackMessage message) {
        String css;
        switch (message.getLevel()){
            case FeedbackMessage.SUCCESS:
                css = "alert success";
                break;
            case FeedbackMessage.INFO:
                css = "alert info";
                break;
            case FeedbackMessage.ERROR:
                css = "alert error";
                break;
            default:
                css = "alert";
        }

        return css;
    }
}
