/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

/**
 * リソースプロパティから値を取得するユーティリティクラスです。
 *
 * @author WaBit
 */
public class MessageUtils {

    /** コード値：フリーフォーマット */
    public static final String CODE_FREE = "FREE";

    private static Locale locale = Locale.getDefault();
    private static List<String> pathList = new ArrayList<String>();
    private static List<ResourceBundle> resources = new ArrayList<ResourceBundle>();

    static {
        pathList.add("com.wabit.uecs.pi.util.MessageUtils");
        refresh();
    }

    // 隠ぺい
    private MessageUtils() {
    }

    // 内部リソース更新
    private static synchronized void refresh() {
        resources.clear();
        for (String path : pathList) {
            resources.add(ResourceBundle.getBundle(path, locale));
        }
    }

    /**
     * ロケールを切り替えます。
     * @param newLocale
     */
    public static void changeLocale(Locale newLocale) {
        locale = newLocale;
        refresh();
    }

    /**
     * メッセージリソースを追加します。
     * @param resourcePath
     */
    public static void addResource(String resourcePath) {
        pathList.add(resourcePath);
        refresh();
    }


    /**
     * メッセージを取得します。
     * @param code メッセージコード
     * @param args 埋め込みワード
     * @return 生成されたメッセージ
     */
    public static String getMessage(String code, Object... args ) {
        String message = null;
        for (ResourceBundle rb : resources) {
            if (rb.containsKey(code)) {
                message = rb.getString(code);
                break;
            }
        }
        return MessageFormat.format(message, args);
    }

}
