/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.device.serial;

import com.wabit.uecs.pi.device.PiDeviceBase;

/**
 * シリアル通信で制御されるデバイスの基底クラスです。
 *
 */
public abstract class SerialPortDeviceBase<T extends SerialPortDeviceConfig> extends PiDeviceBase<T> implements ISerialPortListener {

    private ISerialPortClient serialPortClient;

    private boolean isEnabled = false;

    /**
     *
     * @param deviceId
     * @param config
     */
    public SerialPortDeviceBase(String deviceId, T config) {
        super(deviceId, config);
    }


    @Override
    protected void onInit() throws Exception {
        super.onInit();
        String clsClass = getConfig().getString(SerialPortDeviceConfig.KEY_SERIAL_PORT_CLIENT_CLASS);
        serialPortClient = (ISerialPortClient) Class.forName(clsClass).newInstance();
        serialPortClient.init(getConfig());
        serialPortClient.addListener(this);
        isEnabled = true;
    }

    @Override
    protected void onStart() throws Exception {
        super.onStart();
        if (isEnabled) {
            serialPortClient.open();
        }

    }

    @Override
    protected void onStop() throws Exception {
        if (isEnabled) {
            serialPortClient.close();
        }
        super.onStop();
    }

    /**
     * 内部で使用しているシリアル通信クライアント実装を取得します。
     * @return クライアント実装インスタンス
     */
    public ISerialPortClient getSerialPortClient() {
        return serialPortClient;
    }

    /**
     * データ送信します。
     * @param data 送信データ
     * @throws Exception 処理に失敗するとスローされます。
     */
    public void sendData(byte[] data) throws Exception {
        serialPortClient.sendData(data);
    }


}
