/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.device.serial;

import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.pi4j.io.serial.Serial;
import com.pi4j.io.serial.SerialDataEvent;
import com.pi4j.io.serial.SerialDataEventListener;
import com.pi4j.io.serial.impl.SerialImpl;
import com.wabit.uecs.pi.util.BytesUtils;

/**
 * PI4Jのシリアル通信APIを用いた実装クラスです。
 *
 * @author WaBit
 */
public class SerialPortClientPi4jImpl extends SerialPortClientBase implements SerialDataEventListener {

    private Log logger = LogFactory.getLog(getClass());
    private Serial serial;
    private String portId;
    private int speed;

    @Override
    public void init(SerialPortDeviceConfig conf) throws Exception {
        serial = new SerialImpl();
        portId = conf.getString(SerialPortDeviceConfig.KEY_SERIAL_PORT_ID);
        speed = conf.getInt(SerialPortDeviceConfig.KEY_SERIAL_PORT_SPEED, 9600);
        serial.addListener(this);
    }

    @Override
    public void open() throws Exception {
        logger.info("open port=" + portId);
        serial.open(portId, speed);
    }

    @Override
    public void close() throws Exception {
        logger.info("close port=" + portId);
        if (!serial.isClosed()) {
            serial.close();
        }
    }

    @Override
    public void sendData(byte[] data) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("write data : "  + BytesUtils.toHexString(data));
        }
        serial.write(data);
    }

    @Override
    public void dataReceived(SerialDataEvent event) {
        try {
            byte[] data = event.getBytes();
            if (logger.isDebugEnabled()) {
                logger.debug("read size : "  + data.length + "bytes");
                logger.debug("read data : "  + BytesUtils.toHexString(data));
            }
            fireDataAvailableEvent(data);
        } catch (IOException e) {
            logger.warn(e.getMessage(), e);
        }
    }

}
