/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.device.gpio;

import com.wabit.uecs.CcmService;
import com.wabit.uecs.device.actuator.AbstractCcmListenerAction;
import com.wabit.uecs.device.actuator.ActuatorComponent;
import com.wabit.uecs.pi.device.IPositioner;
import com.wabit.uecs.pi.device.ISwitcher;

/**
 * 遠隔制御指示CCM（rcA.kNN）による動作を実装したクラスです。
 *
 * @author WaBit
 */
public class RcAListenerAction extends AbstractCcmListenerAction {


    @Override
    public void onStart(ActuatorComponent<?> component) throws Exception {
        execute(component);
    }

    /**
     * rcAで指定された方向(値が移動先の位置)に動作させます。
     */
    @Override
    public void execute(ActuatorComponent<?> component) throws Exception {
        CcmService ccmSv = component.getActiveRcAService();
        if (ccmSv == null || ccmSv.getCcm() == null) {
            return;
        }
        Number num = ccmSv.getCcm().getNumberValue();
        if (component instanceof IPositioner) {
            // rcA受信は目標位置まで移動させる
            IPositioner posAct = (IPositioner)component;
            if (num.intValue() <= 0) {
                // 0以下は全閉
                posAct.setPosition(0);
            } else {
                posAct.setPosition(num.intValue());
            }
        } else if (component instanceof ISwitcher) {
            // スイッチは単純設定
            component.setValue(num);
        }

    }

}
