/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.device.gpio;

import com.wabit.uecs.pi.device.PiSensorConfig;

/**
 * GPIOピンに接続されたセンサの設定値クラスです。
 *
 * @author WaBit
 */
public class DigitalSensorConfig extends PiSensorConfig {

    /** 設定項目キー : GPIOピン番号(入力ピン) */
    public static final String KEY_GPIO_PIN_SENSE_INPUT = "GpioPinSenseIn";

    /** 設定項目キー : 入力ピン抵抗状態 */
    public static final String KEY_PIN_PULL_REGISTSANCE = "PinPullRegistance";

    /** 設定項目キー : 入力ピンのデバウンス時間 */
    public static final String KEY_PIN_INPUT_DEBOUNCE = "PinInputDebounce";


    public DigitalSensorConfig() {
    }

}
