/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.device.gpio;

/**
 * アナログ位置制御アクチュエータの設定値クラスです。
 *
 * @author WaBit
 */
public class AnalogPositioningActuatorConfig extends GpioActuatorConfig {

    private static final long serialVersionUID = 1L;

    /** 設定項目キー : GPIOピン番号(入力) */
    public static final String KEY_GPIO_PIN_IN = "GpioPinIn";
    /** 設定項目キー : GPIOピン番号(出力) */
    public static final String KEY_GPIO_PIN_OUT = "GpioPinOut";
    /** 設定項目キー : GPIOピンモード */
    public static final String KEY_GPIO_PIN_OUT_MODE = "GpioPinOutMode";
    /** 設定項目キー : アナログ入力レンジ値 */
    public static final String KEY_ANALOG_RANGE_IN = "AnalogRangeIn";
    /** 設定項目キー : アナログ出力レンジ値 */
    public static final String KEY_ANALOG_RANGE_OUT = "AnalogRangeOut";

    /** ピンモード定数 PWM */
    public static final String VAL_PIN_MODE_PWM = "PWM";
    /** ピンモード定数 Analog */
    public static final String VAL_PIN_MODE_ANALOG = "ANALOG";

    public AnalogPositioningActuatorConfig() {
        // デフォルト値
        setString(KEY_GPIO_PIN_OUT_MODE, VAL_PIN_MODE_PWM);
        setInt(KEY_ANALOG_RANGE_OUT, 100);
    }

}
