/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.device;

import com.wabit.uecs.UecsConstants;
import com.wabit.uecs.device.ComponentConfig;

/**
 * センサーの設定値クラスです。
 *
 * @author WaBit
 */
public class PiSensorConfig extends ComponentConfig {

    /** 変換式：なし(生値) */
    public static final String CONV_TYPE_RAW = "RAW";
    /** 変換式：二次式 */
    public static final String CONV_TYPE_QUADRATIC = "QUADRATIC";
    /** 変換式：サーミスタ式 */
    public static final String CONV_TYPE_THERMISTOR = "THERMISTOR";

    private static final long serialVersionUID = 1L;
    /** 設定キー：データ記録間隔(秒) */
    public static final String KEY_RECORD_INTERVAL = "RecordInterval";
    /** 設定キー：データ最終記録日時  */
    public static final String KEY_LAST_RECORDED_TIME = "LastRecordedTime";

    /** 設定キー：スケール変換方式 */
    public static final String KEY_CONV_TYPE = "ConversionType";
    /** 設定キー：二次式0次係数 */
    public static final String KEY_COEFF_0 = "Coeff0";
    /** 設定キー：二次式1次係数 */
    public static final String KEY_COEFF_1 = "Coeff1";
    /** 設定キー：二次式2次係数 */
    public static final String KEY_COEFF_2 = "Coeff2";
    /** 設定キー：最小値 */
    public static final String KEY_LIMIT_MIN = "LimitMin";
    /** 設定キー：最大値 */
    public static final String KEY_LIMIT_MAX = "LimitMax";

    /** 設定キー：プルアップ抵抗値(Ω) */
    public static final String KEY_PULLUP_R = "PullupR";
    /** 設定キー：標準抵抗値(Ω) */
    public static final String KEY_STD_R = "StdR";
    /** 設定キー：標準温度(℃) */
    public static final String KEY_STD_TEMP = "StdTemp";
    /** 設定キー：B定数(K)) */
    public static final String KEY_CONST_B = "ConstB";
    /** 設定キー：電源電圧(V)) */
    public static final String KEY_POWER_V = "PowerV";

    /** 設定キー：値検出方式 */
    public static final String KEY_DETECTION_METHOD = "DetectionMethod";
    /** 設定キー：検出時間 */
    public static final String KEY_DETECTION_INTERVAL = "DetectionInterval";
    /** 検出方式：瞬時値 */
    public static final String DETECTION_MOMENT = "MOMENT";
    /** 検出方式：単純移動平均(SMA) */
    public static final String DETECTION_SMA = "SMA";
    /** 検出方式：加重移動平均(WMA) */
    public static final String DETECTION_WMA = "WMA";

    /**
     * コンストラクタです。
     */
    public PiSensorConfig() {
        setString(KEY_COMPONENT_NAME, "");
        setString(KEY_CCM_SIDE, Character.toString(UecsConstants.SENDER));
        setString(KEY_CONV_TYPE, CONV_TYPE_RAW);
        setString(KEY_DETECTION_METHOD, DETECTION_MOMENT);
    }
}
