/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.device;

import com.wabit.uecs.device.ComponentConfig;

/**
 * アクチュエータの設定値クラスです。
 *
 * @author WaBit
 */
public class PiActuatorConfig extends ComponentConfig {

    private static final long serialVersionUID = 1L;

    /** 設定キー：データ記録間隔(秒) */
    public static final String KEY_RECORD_INTERVAL = "RecordInterval";

    /** 設定項目キー：動作ログ出力 */
    public static final String KEY_LOG_ENABLED = "LogEnabled";
    /**
     * コンストラクタ
     */
    public PiActuatorConfig() {
        setString(ComponentConfig.KEY_COMPONENT_NAME, "");
    }

}
