package com.wabit.uecs.pi.device;

/**
 * スイッチ動作(ON/OFF)を行う機器機能インタフェースです。
 *
 * @author WaBit
 */
public interface ISwitcher {

    /** ON状態 */
    public static final int OFF = 0;
    /** OFF状態 */
    public static final int ON = 1;

    /**
     * ON状態に設定します。
     */
    public void on();

    /**
     * OFF状態に設定します。
     */
    public void off();

    /**
     * ON状態であるかを返します。
     * @return ON状態の場合true
     */
    public boolean isOn();

    /**
     * OFF状態であるかを返します。
     * @return OFF状態の場合true
     */
    public boolean isOff();
}
