/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.db;

import java.io.Serializable;
import java.util.Date;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.table.DatabaseTable;

/**
 * WebUI表示用ログ情報のDBエンティティです。
 *
 * @author WaBit
 */
@DatabaseTable(tableName = "log")
public class LogEntity implements Serializable {

    private static final long serialVersionUID = 7516041297688970794L;

    /** カラム名:ログNo */
    public static final String LOG_NO = "log_no";
    /** カラム名:カテゴリ */
    public static final String CATEGORY = "category";
    /** カラム名:日時 */
    public static final String TIME = "time";
    /** カラム名:メッセージ */
    public static final String MESSAGE = "message";

    @DatabaseField(columnName = LOG_NO, id = true, allowGeneratedIdInsert = false)
    private Integer logNo;
    @DatabaseField(columnName = CATEGORY, index = true)
    private String category;
    @DatabaseField(columnName = TIME, canBeNull = false)
    private Date time;
    @DatabaseField(columnName = MESSAGE, canBeNull = false)
    private String message;

    /**
     * ログ番号を取得します。
     * @return ログNo
     */
    public Integer getLogNo() {
        return logNo;
    }

    /**
     * ログ番号を設定します。
     * @param logNo ログ番号
     */
    public void setLogNo(Integer logNo) {
        this.logNo = logNo;
    }

    /**
     * カテゴリを取得します。
     * @return カテゴリ
     */
    public String getCategory() {
        return category;
    }

    /**
     * カテゴリを設定します。
     * @param category カテゴリ
     */
    public void setCategory(String category) {
        this.category = category;
    }

    /**
     * 日時を取得します。
     * @return 日時
     */
    public Date getTime() {
        return time;
    }

    /**
     * 日時を設定します。
     * @param time 日時
     */
    public void setTime(Date time) {
        this.time = time;
    }

    /**
     * メッセージを取得します。
     * @return メッセージ
     */
    public String getMessage() {
        return message;
    }

    /**
     * メッセージを設定します。
     * @param message メッセージ
     */
    public void setMessage(String message) {
        this.message = message;
    }

}
