package myapp.webui.sample4;

import java.util.concurrent.Callable;

import myapp.device.sample4.I2cCo2Sensor;
import myapp.device.sample4.I2cCo2SensorConfig;
import myapp.device.sample4.SimpleI2cDevice;
import myapp.webui.MyUIApplication;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.validation.validator.RangeValidator;
import org.apache.wicket.validation.validator.StringValidator;

import com.wabit.uecs.pi.UecsPiNode;
import com.wabit.uecs.pi.db.DatabaseManager;
import com.wabit.uecs.pi.db.DatabaseUtils;
import com.wabit.uecs.pi.device.i2c.I2cDeviceConfig;
import com.wabit.uecs.pi.util.MessageCode;
import com.wabit.uecs.pi.util.MessageUtils;
import com.wabit.uecs.pi.webui.LayoutPage;
import com.wabit.uecs.util.PropertyConfig;

/**
 * クラスコメントを記述してください
 */
@AuthorizeInstantiation({ Roles.ADMIN })
public class I2cDevicePage extends LayoutPage {
    private static final long serialVersionUID = 9205561784306869639L;

    private Form<PropertyConfig> deviceForm;
    private PropertyConfig formParams = new PropertyConfig();
    private Log logger = LogFactory.getLog(getClass());
    private String deviceId;

    public I2cDevicePage() {
    }

    public I2cDevicePage(IModel<?> settingsModel) {
        super(settingsModel);
    }

    public I2cDevicePage(PageParameters parameters) {
        super(parameters);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        UecsPiNode node = MyUIApplication.getNodeInstance();
        SimpleI2cDevice device = node.listDevices(SimpleI2cDevice.class).get(0);
        deviceId = device.getId();
        formParams.setString(I2cDeviceConfig.KEY_I2C_ADDRESS,
                device.getConfig().getString(I2cDeviceConfig.KEY_I2C_ADDRESS));

        I2cCo2Sensor sensor = device.listComponents(I2cCo2Sensor.class).get(0);
        formParams.setString(I2cCo2SensorConfig.KEY_SENSE_INTERVAL,
                sensor.getConfig().getString(I2cCo2SensorConfig.KEY_SENSE_INTERVAL));

        deviceForm = new Form<PropertyConfig>("deviceForm") {
            private static final long serialVersionUID = 1L;

            @Override
            public void onSubmit() {
                try {
                    deviceForm.modelChanging();
                    DatabaseManager.callInTransaction(new Callable<Void>() {
                        public Void call() throws Exception {

                            SimpleI2cDevice device = (SimpleI2cDevice) MyUIApplication.getNodeInstance()
                                    .getDevice(deviceId);
                            I2cCo2Sensor sensor = device.listComponents(I2cCo2Sensor.class).get(0);
                            device.getConfig().setString(I2cDeviceConfig.KEY_I2C_ADDRESS,
                                    formParams.getString(I2cDeviceConfig.KEY_I2C_ADDRESS));
                            sensor.getConfig().setInt(I2cCo2SensorConfig.KEY_SENSE_INTERVAL,
                                    formParams.getInt(I2cCo2SensorConfig.KEY_SENSE_INTERVAL));
                            DatabaseUtils.saveDevice(device);
                            MyUIApplication.getNodeInstance().restart();
                            return null;
                        }
                    });
                    deviceForm.modelChanged();
                    success(MessageUtils.getMessage(MessageCode.SAVED));
                } catch (Exception e) {
                    error(MessageUtils.getMessage(MessageCode.ERROR));
                    logger.error("save error.", e);
                }
            }
        };

        deviceForm.setDefaultModel(new CompoundPropertyModel<PropertyConfig>(formParams));
        deviceForm.add(new RequiredTextField<String>(I2cDeviceConfig.KEY_I2C_ADDRESS, String.class)
                .add(new StringValidator(2, 2)));
        deviceForm.add(new RequiredTextField<Integer>(I2cCo2SensorConfig.KEY_SENSE_INTERVAL,
                Integer.class)
                .add(new RangeValidator<Integer>(0, Integer.MAX_VALUE)));
        add(deviceForm);

    }
}
