package myapp.device.sample4;

import com.wabit.uecs.device.ComponentConfig;
import com.wabit.uecs.device.IComponent;
import com.wabit.uecs.pi.UecsPiNodeConfig;
import com.wabit.uecs.pi.device.i2c.I2cDeviceBase;

public class SimpleI2cDevice extends I2cDeviceBase<SimpleI2cDeviceConfig> {

    public SimpleI2cDevice(String deviceId) {
        super(deviceId, new SimpleI2cDeviceConfig());
    }

    @Override
    protected void onInit() throws Exception {
        super.onInit();

        UecsPiNodeConfig nconf = (UecsPiNodeConfig) getNode().getConfig();
        for (IComponent<?> compo : listComponents()) {
            // アクチュエータCCMの属性値として、ノードのCCM属性値を引き継いで設定
            ComponentConfig conf = compo.getConfig();
            conf.setInt(ComponentConfig.KEY_CCM_ROOM, nconf.getInt(UecsPiNodeConfig.KEY_NODE_ROOM, 0));
            conf.setInt(ComponentConfig.KEY_CCM_REGION, nconf.getInt(UecsPiNodeConfig.KEY_NODE_REGION, 0));
            conf.setInt(ComponentConfig.KEY_CCM_ORDER, nconf.getInt(UecsPiNodeConfig.KEY_NODE_ORDER, 0));
            conf.setInt(ComponentConfig.KEY_CCM_PRIORITY, nconf.getInt(UecsPiNodeConfig.KEY_NODE_PRIORITY, 0));
        }
    }
}
