/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.webui;

import java.util.Arrays;

import org.apache.wicket.markup.html.form.DropDownChoice;

import com.wabit.uecs.CcmLevel;

/**
 * CCM送受信レベル選択用共通パーツです。
 *
 * @author WaBit
 *
 */
public class CcmLevelChoice extends DropDownChoice<String> {
    private static String[] ccmLevels = new String[] {
        CcmLevel.A_1S_0.toString(),
        CcmLevel.A_1S_1.toString(),
        CcmLevel.A_10S_0.toString(),
        CcmLevel.A_10S_1.toString(),
        CcmLevel.A_1M_0.toString(),
        CcmLevel.A_1M_1.toString(),
        CcmLevel.B_0.toString(),
        CcmLevel.B_1.toString(),
};

    /**
     * CCM送信レベルを内部リストに持ったChoiceを生成します。
     * @param id 画面コンポーネントID
     */
    public CcmLevelChoice(String id) {
        super(id, Arrays.asList(ccmLevels));
        setRequired(true);
        setNullValid(false);
    }

}
