/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.device.gpio;

import com.wabit.uecs.pi.device.PiActuatorConfig;

/**
 * GPIOピンに接続されたアクチュエータの設定値クラスです。
 *
 * @author WaBit
 */
public class GpioActuatorConfig extends PiActuatorConfig {

	private static final long serialVersionUID = 1L;

    /** 設定項目キー : 値逆転 */
    public static final String KEY_INVERSE = "InverseMode";
    /** 設定項目キー : 動作モード  */
    public static final String KEY_ACTION_MODE = "ActionMode";
    /** 設定項目キー : デフォルト値 */
    public static final String KEY_DEFAULT_VALUE = "DefaultValue";
    /** 設定項目キー : 固定の位置 */
    public static final String KEY_FIXED_VALUE = "FixedValue";
    /** 設定項目キー : 直前までの動作位置 */
    public static final String KEY_LAST_VALUE = "LastValue";
    /** 設定項目キー : GPIOピン番号(インターロックモード選択) */
    public static final String KEY_GPIO_PIN_INTERLOCK = "GpioPinInterlock";

    /**
     * コンストラクタです。
     */
    public GpioActuatorConfig() {
        setInt(KEY_DEFAULT_VALUE, 0);
        setBoolean(KEY_INVERSE, false);
        setBoolean(KEY_IS_REPRESENTATIVE, false);
    }
}
