/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2012-2014 WaBit Inc. All rights reserved.
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.wabit.uecs.pi.device.gpio;

/**
 * GPIO端子のデジタル出力でスイッチ(ON/OFF)制御を行うアクチュエータの設定値クラスです。
 *
 * @author WaBit
 */
public class DigitalSwitchActuatorConfig extends GpioActuatorConfig {

    private static final long serialVersionUID = 1L;

    /** 設定項目キー : GPIOピン番号(ON/OFF出力) */
    public static final String KEY_GPIO_PIN_SW_OUT = "GpioPinSwOut";

    /** 設定項目キー : GPIOピン番号(ON/OFF入力) */
    public static final String KEY_GPIO_PIN_SW_IN = "GpioPinSwIn";

    public DigitalSwitchActuatorConfig() {
        setInt(KEY_DEFAULT_VALUE, 0);
        setInt(KEY_FIXED_VALUE, 0);
        setBoolean(KEY_INVERSE, false);
        setBoolean(KEY_IS_REPRESENTATIVE, false);
    }
}
