/*
 * Decompiled with CFR 0.152.
 */
package com.wabit.uecs.pi.webui.top;

import com.wabit.uecs.CcmService;
import com.wabit.uecs.device.IDevice;
import com.wabit.uecs.device.sensor.SensorComponent;
import com.wabit.uecs.pi.webui.WebUIApplication;
import com.wabit.uecs.pi.webui.top.SensorRow;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import org.apache.wicket.Component;
import org.apache.wicket.datetime.markup.html.basic.DateLabel;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class SensorsPanel
extends Panel {
    private static final long serialVersionUID = -3708813079941308934L;

    public SensorsPanel(String id) {
        super(id);
        this.setRenderBodyOnly(true);
        ArrayList<SensorRow> sensorList = new ArrayList<SensorRow>();
        for (IDevice device : WebUIApplication.getNodeInstance().listDevices()) {
            for (SensorComponent sensor : device.listComponents(SensorComponent.class)) {
                SensorRow row = new SensorRow();
                row.setName(sensor.getConfig().getString("ComponentName"));
                row.setUnit(sensor.getConfig().getString("CcmUnit"));
                CcmService ccmService = sensor.getCcmService();
                if (ccmService != null && ccmService.isEnable() && ccmService.getUpdateTime() > 0L) {
                    if (!ccmService.isExpired() && ccmService.getCcm().getNumberValue() != null) {
                        row.setValue(ccmService.getCcm().getStringValue());
                    } else {
                        row.setValue("--");
                    }
                    row.setUpdateTime(new Date(sensor.getCcmService().getUpdateTime()));
                }
                sensorList.add(row);
            }
        }
        this.add(new Component[]{new ListView<SensorRow>("componentList", sensorList){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<SensorRow> item) {
                item.add(new Component[]{new Label("idx", (Serializable)Integer.valueOf(item.getIndex() + 1))});
                item.add(new Component[]{new Label("name", ((SensorRow)item.getModelObject()).getName())});
                if (((SensorRow)item.getModelObject()).getValue() != null) {
                    item.add(new Component[]{new Label("value", ((SensorRow)item.getModelObject()).getValue())});
                } else {
                    item.add(new Component[]{new Label("value", "--")});
                }
                item.add(new Component[]{new Label("unit", ((SensorRow)item.getModelObject()).getUnit())});
                if (((SensorRow)item.getModelObject()).getUpdateTime() != null) {
                    item.add(new Component[]{DateLabel.forDatePattern((String)"updateTime", (IModel)Model.of((Serializable)((SensorRow)item.getModelObject()).getUpdateTime()), (String)"yyyy-MM-dd HH:mm:ss")});
                } else {
                    item.add(new Component[]{new Label("updateTime", "--")});
                }
            }
        }});
    }
}

