/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.system;

import com.pi4j.system.SystemInfo;
import java.io.IOException;
import java.text.ParseException;

public interface SystemInfoProvider {
    public String getProcessor() throws IOException, InterruptedException, UnsupportedOperationException;

    public String getModelName() throws IOException, InterruptedException, UnsupportedOperationException;

    public String getBogoMIPS() throws IOException, InterruptedException, UnsupportedOperationException;

    public String[] getCpuFeatures() throws IOException, InterruptedException, UnsupportedOperationException;

    public String getCpuImplementer() throws IOException, InterruptedException, UnsupportedOperationException;

    public String getCpuArchitecture() throws IOException, InterruptedException, UnsupportedOperationException;

    public String getCpuVariant() throws IOException, InterruptedException, UnsupportedOperationException;

    public String getCpuPart() throws IOException, InterruptedException, UnsupportedOperationException;

    public String getCpuRevision() throws IOException, InterruptedException, UnsupportedOperationException;

    public String getHardware() throws IOException, InterruptedException, UnsupportedOperationException;

    public String getRevision() throws IOException, InterruptedException, UnsupportedOperationException;

    public String getSerial() throws IOException, InterruptedException, UnsupportedOperationException;

    public String getOsName() throws UnsupportedOperationException;

    public String getOsVersion() throws UnsupportedOperationException;

    public String getOsArch() throws UnsupportedOperationException;

    public String getOsFirmwareBuild() throws IOException, InterruptedException, UnsupportedOperationException;

    public String getOsFirmwareDate() throws IOException, InterruptedException, ParseException, UnsupportedOperationException;

    public String getJavaVendor() throws UnsupportedOperationException;

    public String getJavaVendorUrl() throws UnsupportedOperationException;

    public String getJavaVersion() throws UnsupportedOperationException;

    public String getJavaVirtualMachine() throws UnsupportedOperationException;

    public String getJavaRuntime() throws UnsupportedOperationException;

    public boolean isHardFloatAbi() throws UnsupportedOperationException;

    public long getMemoryTotal() throws IOException, InterruptedException, UnsupportedOperationException;

    public long getMemoryUsed() throws IOException, InterruptedException, UnsupportedOperationException;

    public long getMemoryFree() throws IOException, InterruptedException, UnsupportedOperationException;

    public long getMemoryShared() throws IOException, InterruptedException, UnsupportedOperationException;

    public long getMemoryBuffers() throws IOException, InterruptedException, UnsupportedOperationException;

    public long getMemoryCached() throws IOException, InterruptedException, UnsupportedOperationException;

    public SystemInfo.BoardType getBoardType() throws IOException, InterruptedException, UnsupportedOperationException;

    public float getCpuTemperature() throws IOException, InterruptedException, NumberFormatException, UnsupportedOperationException;

    public float getCpuVoltage() throws IOException, InterruptedException, NumberFormatException, UnsupportedOperationException;

    public float getMemoryVoltageSDRam_C() throws IOException, InterruptedException, NumberFormatException, UnsupportedOperationException;

    public float getMemoryVoltageSDRam_I() throws IOException, InterruptedException, NumberFormatException, UnsupportedOperationException;

    public float getMemoryVoltageSDRam_P() throws IOException, InterruptedException, NumberFormatException, UnsupportedOperationException;

    public boolean getCodecH264Enabled() throws IOException, InterruptedException, UnsupportedOperationException;

    public boolean getCodecMPG2Enabled() throws IOException, InterruptedException, UnsupportedOperationException;

    public boolean getCodecWVC1Enabled() throws IOException, InterruptedException, UnsupportedOperationException;

    public long getClockFrequencyArm() throws IOException, InterruptedException, UnsupportedOperationException;

    public long getClockFrequencyCore() throws IOException, InterruptedException, UnsupportedOperationException;

    public long getClockFrequencyH264() throws IOException, InterruptedException, UnsupportedOperationException;

    public long getClockFrequencyISP() throws IOException, InterruptedException, UnsupportedOperationException;

    public long getClockFrequencyV3D() throws IOException, InterruptedException, UnsupportedOperationException;

    public long getClockFrequencyUART() throws IOException, InterruptedException, UnsupportedOperationException;

    public long getClockFrequencyPWM() throws IOException, InterruptedException, UnsupportedOperationException;

    public long getClockFrequencyEMMC() throws IOException, InterruptedException, UnsupportedOperationException;

    public long getClockFrequencyPixel() throws IOException, InterruptedException, UnsupportedOperationException;

    public long getClockFrequencyVEC() throws IOException, InterruptedException, UnsupportedOperationException;

    public long getClockFrequencyHDMI() throws IOException, InterruptedException, UnsupportedOperationException;

    public long getClockFrequencyDPI() throws IOException, InterruptedException, UnsupportedOperationException;
}

